CREATE DATABASE LigaKreglarskaZmiana CHARACTER SET utf8 COLLATE utf8_general_ci;

USE LigaKreglarskaZmiana;

CREATE TABLE Wyniki_kreglarzy (
	IDMeczu int NOT NULL DEFAULT 0 ,
	NumerGry smallint NOT NULL DEFAULT 0 ,
	IDKreglarza int NOT NULL DEFAULT 0 ,
	WynikCzysty smallint NULL DEFAULT 0 ,
	WynikHandicap smallint NULL DEFAULT 0 ,
	GraWygrana bit NOT NULL DEFAULT 0 
);

CREATE TABLE Wyniki_kreglarzy_archiwum (
	IDMeczu int NOT NULL DEFAULT 0 ,
	NumerGry smallint NOT NULL DEFAULT 0 ,
	IDKreglarza int NOT NULL DEFAULT 0 ,
	WynikCzysty smallint NULL DEFAULT 0 ,
	WynikHandicap smallint NULL DEFAULT 0 ,
	GraWygrana bit NOT NULL DEFAULT 0 
);

CREATE TABLE Kreglarze (
	IDKreglarza int NOT NULL AUTO_INCREMENT PRIMARY KEY ,
	NazwiskoKreglarza nvarchar (50) NULL ,
	ImieKreglarza nvarchar (50) NULL ,
	SrodkowyInicjalKreglarza nvarchar (1) NULL ,
	AdresKreglarza nvarchar (50) NULL ,
	MiastoKreglarza nvarchar (50) NULL ,
	StanZamKreglarza nvarchar (2) NULL ,
	KodPocztowyKreglarza nvarchar (10) NULL ,
	TelefonKreglarza nvarchar (14) NULL ,
	IDDruzyny int NULL ,
	LiczbaZbitychKregli int NULL DEFAULT 0 ,
	LiczbaRozegranychGier int NULL DEFAULT 0 ,
	BiezacaSredniaKreglarza smallint NULL DEFAULT 0 ,
	BiezacyHandicapKreglarza smallint NULL DEFAULT 0 
);

CREATE TABLE Gry_meczowe (
	IDMeczu int NOT NULL DEFAULT 0 ,
	NumerGry smallint NOT NULL DEFAULT 0 ,
	IDWygranejDruzyny int NULL DEFAULT 0 
);

CREATE TABLE Gry_meczowe_archiwum (
	IDMeczu int NOT NULL DEFAULT 0 ,
	NumerGry smallint NOT NULL DEFAULT 0 ,
	IDWygranejDruzyny int NULL DEFAULT 0 
);

CREATE TABLE Druzyny (
	IDDruzyny int NOT NULL AUTO_INCREMENT PRIMARY KEY ,
	NazwaDruzyny nvarchar (50) NOT NULL ,
	IDKapitana int NULL 
);

CREATE TABLE Turnieje (
	IDTurnieju int NOT NULL AUTO_INCREMENT PRIMARY KEY ,
	DataTurnieju date NULL ,
	LokalizacjaTurnieju nvarchar (50) NULL 
);

CREATE TABLE Turnieje_archiwum (
	IDTurnieju int NOT NULL DEFAULT 0 ,
	DataTurnieju date NULL ,
	LokalizacjaTurnieju nvarchar (50) NULL 
);

CREATE TABLE Mecze_turniejowe (
	IDMeczu int NOT NULL AUTO_INCREMENT PRIMARY KEY ,
	IDTurnieju int NULL DEFAULT 0 ,
	Tory nvarchar (5) NULL ,
	IDDruzynyTorNieparzysty int NULL DEFAULT 0 ,
	IDDruzynyTorParzysty int NULL DEFAULT 0 
);

CREATE TABLE Mecze_turniejowe_archiwum (
	IDMeczu int NOT NULL DEFAULT 0 ,
	IDTurnieju int NULL DEFAULT 0 ,
	Tory nvarchar (5) NULL ,
	IDDruzynyTorNieparzysty int NULL DEFAULT 0 ,
	IDDruzynyTorParzysty int NULL DEFAULT 0 
);

CREATE TABLE KodyWaszyngton (
	ZIP nvarchar (5) NOT NULL ,
	City nvarchar (255) NULL ,
	State nvarchar (255) NULL 
);

ALTER TABLE Wyniki_kreglarzy ADD 
	CONSTRAINT Wyniki_kreglarzy_PK PRIMARY KEY   
	(
		IDMeczu,
		NumerGry,
		IDKreglarza
	)   ;

CREATE  INDEX IDKreglarza ON Wyniki_kreglarzy(IDKreglarza) ;

CREATE  INDEX GryMeczoweWynikiKreglarzy ON Wyniki_kreglarzy(IDMeczu, NumerGry) ;

ALTER TABLE Wyniki_kreglarzy_archiwum ADD 
	CONSTRAINT Wyniki_kreglarzy_archiwum_PK PRIMARY KEY 
	(
		IDMeczu,
		NumerGry,
		IDKreglarza
	)  ;

CREATE  INDEX IDKreglarza ON Wyniki_kreglarzy_archiwum(IDKreglarza);

CREATE  INDEX Gry_meczowe_archiwumWyniki_kreglarzy_archiwum ON Wyniki_kreglarzy_archiwum(IDMeczu, NumerGry);

CREATE  INDEX NazwiskoKreglarza ON Kreglarze(NazwiskoKreglarza) ;

CREATE  INDEX KreglarzeIDDruzyny ON Kreglarze(IDDruzyny) ;

ALTER TABLE Gry_meczowe ADD 
	CONSTRAINT Gry_meczowe_PK PRIMARY KEY   
	(
		IDMeczu,
		NumerGry
	)   ;

CREATE  INDEX IDDruzyny1 ON Gry_meczowe(IDWygranejDruzyny) ;

CREATE  INDEX MeczeTurniejoweGryMeczowe ON Gry_meczowe(IDMeczu) ;

ALTER TABLE Gry_meczowe_archiwum ADD 
	CONSTRAINT Gry_meczowe_archiwum_PK PRIMARY KEY  
	(
		IDMeczu,
		NumerGry
	)  ;

CREATE  INDEX IDDruzyny1 ON Gry_meczowe_archiwum(IDWygranejDruzyny);

CREATE  INDEX Mecze_turniejowe_archiwumGry_meczowe_archiwum ON Gry_meczowe_archiwum(IDMeczu);

ALTER TABLE Turnieje_archiwum ADD 
	CONSTRAINT Turnieje_archiwum_PK PRIMARY KEY 
	(
		IDTurnieju
	)  ;

CREATE  INDEX DruzynyMecze_turniejowe_parzysty ON Mecze_turniejowe(IDDruzynyTorParzysty) ;

CREATE  INDEX DruzynyMecze_turniejowe_nieparzysty ON Mecze_turniejowe(IDDruzynyTorNieparzysty) ;

CREATE  INDEX MeczeTurniejoweIDTurnieju ON Mecze_turniejowe(IDTurnieju) ;

ALTER TABLE Mecze_turniejowe_archiwum ADD 
	CONSTRAINT Mecze_turniejowe_archiwum_PK PRIMARY KEY   
	(
		IDMeczu
	)  ;

CREATE  INDEX IDDruzyny1 ON Mecze_turniejowe_archiwum(IDDruzynyTorNieparzysty);

CREATE  INDEX IDDruzyny2 ON Mecze_turniejowe_archiwum(IDDruzynyTorParzysty);

CREATE  INDEX IDTurnieju ON Mecze_turniejowe_archiwum(IDTurnieju);

ALTER TABLE KodyWaszyngton ADD 
	CONSTRAINT KodyWaszyngton_PK PRIMARY KEY   
	(
		ZIP
	)  ;

ALTER TABLE Wyniki_kreglarzy ADD 
	CONSTRAINT Wyniki_kreglarzy_FK00 FOREIGN KEY 
	(
		IDKreglarza
	) REFERENCES Kreglarze (
		IDKreglarza
	),
	ADD CONSTRAINT Wyniki_kreglarzy_FK01 FOREIGN KEY 
	(
		IDMeczu,
		NumerGry
	) REFERENCES Gry_meczowe (
		IDMeczu,
		NumerGry
	);

ALTER TABLE Wyniki_kreglarzy_archiwum ADD 
	CONSTRAINT Wyniki_kreglarzy_archiwum_FK00 FOREIGN KEY 
	(
		IDMeczu,
		NumerGry
	) REFERENCES Gry_meczowe_archiwum (
		IDMeczu,
		NumerGry
	);

ALTER TABLE Kreglarze ADD 
	CONSTRAINT Kreglarze_FK00 FOREIGN KEY 
	(
		IDDruzyny
	) REFERENCES Druzyny (
		IDDruzyny
	);

ALTER TABLE Gry_meczowe ADD 
	CONSTRAINT Gry_meczowe_FK00 FOREIGN KEY 
	(
		IDMeczu
	) REFERENCES Mecze_turniejowe (
		IDMeczu
	);

ALTER TABLE Gry_meczowe_archiwum ADD 
	CONSTRAINT Gry_meczowe_archiwum_FK00 FOREIGN KEY 
	(
		IDMeczu
	) REFERENCES Mecze_turniejowe_archiwum (
		IDMeczu
	);

ALTER TABLE Mecze_turniejowe ADD 
	CONSTRAINT Mecze_turniejowe_FK00 FOREIGN KEY 
	(
		IDDruzynyTorParzysty
	) REFERENCES Druzyny (
		IDDruzyny
	),
	ADD CONSTRAINT Mecze_turniejowe_FK01 FOREIGN KEY 
	(
		IDDruzynyTorNieparzysty
	) REFERENCES Druzyny (
		IDDruzyny
	),
	ADD CONSTRAINT Mecze_turniejowe_FK02 FOREIGN KEY 
	(
		IDTurnieju
	) REFERENCES Turnieje (
		IDTurnieju
	);

ALTER TABLE Mecze_turniejowe_archiwum ADD 
	CONSTRAINT Mecze_turniejowe_archiwum_FK00 FOREIGN KEY 
	(
		IDTurnieju
	) REFERENCES Turnieje_archiwum (
		IDTurnieju
	);



